/*=========================================================

	detectbuttons.h

	{^̑gݍ킹擾B

=========================================================*/
#ifndef CDIALOG_DETECTBUTTONS_H
#define CDIALOG_DETECTBUTTONS_H

#include "dev.h"
#include "message.h"
#include "psp/padutil.h"

/*=========================================================
	}N
=========================================================*/
#define CDIALOG_DETECTBUTTONS_TITLE_LENGTH 64
#define CDIALOG_DETECTBUTTONS_BUF_LENGTH  128

#ifdef __cplusplus
extern "C" {
#endif

/*=========================================================
	^錾
=========================================================*/
typedef struct {
	char               title[CDIALOG_DETECTBUTTONS_TITLE_LENGTH];
	unsigned int       options;
	PadutilButtons     availButtons;
	PadutilButtons     *buttons;
} CdialogDetectbuttonsData;

struct cdialog_detectbuttons_work {
	bool detecting;
	bool waitForRelease;
	PadutilButtons buttons;
	char buf[CDIALOG_DETECTBUTTONS_BUF_LENGTH];
	PadutilButtonName *buttonNames;
};

typedef struct {
	bool destroySelf;
	struct cdialog_dev_base_params base;
	CdialogDetectbuttonsData data;
	struct cdialog_detectbuttons_work work;
	bool showMessage;
} CdialogDetectbuttonsParams;

/*=========================================================
	֐
=========================================================*/
int cdialogDetectbuttonsInit( CdialogDetectbuttonsParams *params );
CdialogDetectbuttonsData *cdialogDetectbuttonsGetData( void );
CdialogStatus cdialogDetectbuttonsGetStatus( void );
CdialogResult cdialogDetectbuttonsGetResult( void );
int cdialogDetectbuttonsStart( unsigned short x, unsigned short y );
int cdialogDetectbuttonsStartNoLock( unsigned short x, unsigned short y );
int cdialogDetectbuttonsUpdate( void );
int cdialogDetectbuttonsShutdownStartNoLock( void );
int cdialogDetectbuttonsShutdownStart( void );
void cdialogDetectbuttonsDestroy( void );

#ifdef __cplusplus
}
#endif

#endif
